﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class EntityScript : MonoBehaviour
{
    GameController game;
    public string niceName = "(unnamed)";
    public Type type;
    public DialogSceneObject dialogExamine;
    public DialogSceneObject dialogPickUp;
    public DialogSceneObject dialogConversationA;
    public DialogSceneObject dialogConversationB;
    public DialogSceneObject dialogConversationC;
    public bool allowInteract = true;
    public bool interactionTriggersEnding = false;

    public AudioClip soundInteract;

    int interactionCount;
    Collider2D collider_move;
    Collider2D collider_range;
    Rigidbody2D body;

    public enum Type {NPC, PickUp, Fixture, Sign, AutoText};

    // Start is called before the first frame update
    void Start()
    {
        GameObject gameGo = GameObject.Find("/CTRL_Game");
        if (gameGo == null)
        {
            Debug.LogError("No CTRL_Game object present! This means trouble.");
        }
        game = gameGo.GetComponent<GameController>();

        collider_move = GetComponent<BoxCollider2D>();
        collider_range = GetComponent<CircleCollider2D>();
        body = GetComponent<Rigidbody2D>();
    }

    public DialogSceneObject Interact()
    {
        interactionCount++;
        DialogSceneObject returnDialog = null;

        // play sound effect
        if (soundInteract != null)
        {
            game.sfxPlayer.clip = soundInteract;
            game.sfxPlayer.Play();
        }


        switch (type)
        {
            case Type.PickUp:
                {
                    Destroy(this.gameObject);
                    if (dialogPickUp != null)
                    {
                        returnDialog = dialogPickUp;
                    }
                    else
                    {
                        returnDialog = dialogExamine;
                    }
                } break;

            case Type.NPC:
                {
                    game.startDialog(dialogConversationA);
                } break;

            default:
                {
                    returnDialog = dialogExamine;
                } break;
        }


        // special case to start outro
        if (interactionTriggersEnding)
        {
            game.state = GameController.GameState.ToOutro;
            return null;
        }

        return returnDialog;
    }



    // Update is called once per frame
    void Update()
    {
        
    }
}
