﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class GameController : MonoBehaviour
{
    public GameObject TextGameObject;
    public bool allowPlayerMovement = true;
    public bool allowPlayerInteractions = true;
    public GameState state;

    public DialogSceneObject entryPrologue;
    public DialogSceneObject entryIntro;
    public DialogSceneObject entryOutro;
    public DialogSceneObject entryEpilogue;

    public AudioSource musicPlayer;
    public AudioSource sfxPlayer;

    public AudioClip soundConfirm1;
   
    public List<string> nothings = new List<string>();

    DialogSceneObject dialogSceneCurrent;
    TextController tc;

    bool countRocks = true;
    int initialRockCount = 0;
    float countRocksCooldownInit = 1f;
    float countRocksCooldown;

    bool helpedWithRockslide = false;

    EntityScript npc_scully;
    EntityScript npc_hermit;


    public enum GameState {ToPrologue, Prologue,
                           ToIntro, Intro,
                           ToRoaming, Roaming,
                           ToDialog, Dialog,
                           ToOutro, Outro,
                           ToEpilogue, Epilogue
    }

    // Start is called before the first frame update
    void Start()
    {
        npc_scully = GameObject.Find("NPC_scully").GetComponent<EntityScript>();
        npc_hermit = GameObject.Find("NPC_hermit").GetComponent<EntityScript>();

        GameObject[] rocks = GameObject.FindGameObjectsWithTag("RockslideRock");
        initialRockCount = rocks.Length;

        // feed NPCs their default lines:

        tc = TextGameObject.GetComponent<TextController>();
        state = GameState.ToPrologue;
        countRocksCooldown = countRocksCooldownInit;
    }

    // Update is called once per frame
    void Update()
    {
        if (Input.GetButtonUp("Quit"))
        {
            Application.Quit();
        }

        switch (state)
        {
            case (GameState.ToPrologue):
                {
                    Debug.Log("To Prologue");
                    allowPlayerMovement = false;
                    allowPlayerInteractions = false;

                    if (entryPrologue == null)
                    {
                        Debug.LogError("entryPrologue was not defined. Make sure it's not empty in the editor!");
                    }

                    tc.doFullImage(true);
                    dialogSceneCurrent = entryPrologue;
                    if (dialogSceneCurrent != null)
                    {
                        tc.doDialogScene(dialogSceneCurrent);
                        state = GameState.Prologue;
                    }
                }
                break;

            case (GameState.Prologue):
                {
                    if (ChoicesCompleted())
                    {
                        state = GameState.ToIntro;
                    }
                }
                break;

            case (GameState.ToIntro):
                {
                    tc.doFullImage(false);
                    Debug.Log("To Intro");
                    allowPlayerMovement = false;
                    allowPlayerInteractions = false;

                    if (entryIntro == null)
                    {
                        Debug.LogError("entryIntro was not defined. Make sure it's not empty in the editor!");
                    }

                    dialogSceneCurrent = entryIntro;
                    if (dialogSceneCurrent != null)
                    {
                        tc.doDialogScene(dialogSceneCurrent);
                        state = GameState.Intro;
                    }
                } break;

            case (GameState.Intro):
                {
                    if (ChoicesCompleted())
                    {
                        tc.clearBox();
                        state = GameState.ToRoaming;
                    }
                }
                break;

            case (GameState.ToDialog):
                {
                    allowPlayerMovement = false;
                    allowPlayerInteractions = false;
                    state = GameState.Dialog;
                } break;

            case (GameState.Dialog):
                {
                    if (ChoicesCompleted())
                    {
                        tc.clearBox();
                        state = GameState.ToRoaming;
                    }
                } break;

            case (GameState.ToRoaming):
                {
                    Debug.Log("ToRoaming");
                    allowPlayerMovement = true;
                    allowPlayerInteractions = true;
                    state = GameState.Roaming;
                } break;

            case (GameState.Roaming):
                {
                    if (countRocks)
                    {
                        countRocksCooldown -= Time.deltaTime;
                        if (countRocksCooldown <= 0)
                        {
                            countRocksCooldown = countRocksCooldownInit;
                            GameObject[] rocks = GameObject.FindGameObjectsWithTag("RockslideRock");

                            if (rocks.Length <= 3) // it's okay to leave a few rocks
                            {
                                helpedWithRockslide = true;
                                countRocks = false;

                                // change NPC's line
                                npc_hermit.dialogConversationA = npc_hermit.dialogConversationB;
                            }
                        }
                    }
                }
                break;

            case (GameState.ToOutro):
                {
                    Debug.Log("ToOutro");

                    allowPlayerMovement = false;
                    allowPlayerInteractions = false;

                    if (entryOutro == null)
                    {
                        Debug.LogError("entryOutro was not defined. Make sure it's not empty in the editor!");
                    }

                    // get world state for the correct ending

                    // rockslide rocks
                    GameObject[] rocks = GameObject.FindGameObjectsWithTag("RockslideRock");
                    int currentRockCount = rocks.Length;
                    if (currentRockCount != initialRockCount)
                    {
                        if (helpedWithRockslide)
                        {
                            addNothing("an entire fricking rock slide (!)");
                        }
                        else
                        {
                            if ((initialRockCount - currentRockCount) >= (initialRockCount * .8f))
                            {
                                addNothing("a few rocks");
                            }
                            else if ((initialRockCount - currentRockCount) >= (initialRockCount * .5f))
                            {
                                addNothing("a whole bunch of rocks");
                            }
                            else if ((initialRockCount - currentRockCount) >= (initialRockCount * .1f))
                            {
                                addNothing("way too many rocks for any purpose");
                            }
                        }
                    }

                    dialogSceneCurrent = entryOutro;
                    if (dialogSceneCurrent != null)
                    {
                        tc.doDialogScene(dialogSceneCurrent);
                        state = GameState.Outro;
                    }
                } break;

            case (GameState.Outro):
                {
                    if (ChoicesCompleted())
                    {
                        state = GameState.ToEpilogue;
                    }
                }
                break;

            case (GameState.ToEpilogue):
                {
                    Debug.Log("To Epilogue");
                    allowPlayerMovement = false;
                    allowPlayerInteractions = false;

                    if (entryEpilogue == null)
                    {
                        Debug.LogError("entryEpilogue was not defined. Make sure it's not empty in the editor!");
                    }

                    tc.doFullImage(true);
                    dialogSceneCurrent = entryEpilogue;
                    if (dialogSceneCurrent != null)
                    {
                        tc.doDialogScene(dialogSceneCurrent);
                        state = GameState.Epilogue;
                    }
                }
                break;

            case (GameState.Epilogue):
                {
                    if (ChoicesCompleted())
                    {
                        Application.Quit();
                    }
                } break;
        }
    }

    public void displayInteraction(DialogSceneObject dialog)
    {
        tc.doDialogScene(dialog);
    }

    public void startDialog(DialogSceneObject dialog)
    {
        dialogSceneCurrent = dialog;
        if (dialogSceneCurrent != null)
        {
            tc.doDialogScene(dialogSceneCurrent);
            state = GameState.ToDialog;
        }
    }

    bool ChoicesCompleted()
    {
        if (Input.GetButtonDown("Interact1"))
        {
            tc.doChoice(0);
            dialogSceneCurrent = tc.getNextDialog();
            tc.doDialogScene(dialogSceneCurrent);
        }
        if (Input.GetButtonDown("Choice1"))
        {
            tc.doChoice(1);
            dialogSceneCurrent = tc.getNextDialog();
            tc.doDialogScene(dialogSceneCurrent);
        }
        if (Input.GetButtonDown("Choice2"))
        {
            tc.doChoice(2);
            dialogSceneCurrent = tc.getNextDialog();
            tc.doDialogScene(dialogSceneCurrent);
        }
        if (Input.GetButtonDown("Choice3"))
        {
            tc.doChoice(3);
            dialogSceneCurrent = tc.getNextDialog();
            tc.doDialogScene(dialogSceneCurrent);
        }

        if (dialogSceneCurrent == null)
        {
            // sequence complete
            
            return true;
        }
        else
        {
            return false;
        }
    }

    public void addNothing(string stringToAdd)
    {
        if (!nothings.Contains(stringToAdd))
        {
            Debug.Log(stringToAdd + " --- added");
            nothings.Add(stringToAdd);
        }
    }

    public string listNothings()
    {
        string returnString = "";
        string[] nothingsArray = nothings.ToArray();

        switch (nothingsArray.Length)
        {
            case 1:
                {
                    returnString = nothingsArray[0];
                } break;

            case 2:
                { 
                    returnString = nothingsArray[0] + " and " + nothingsArray[1];
                } break;

            default:
                {
                    for (int i = 0; i < nothingsArray.Length; i++)
                    {
                        if (i == 0)
                        {
                            returnString = nothingsArray[i];
                            continue;
                        }
                        
                        if (i != nothingsArray.Length - 1)
                        {
                            returnString += ", " + nothingsArray[i];
                        }
                        else
                        {
                            // Oxford Comma ftw!
                            returnString += ", and " + nothingsArray[i];
                        }
                    }
                } break;
        }

        return returnString;
    }
}
