﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class PlayerInteractions : MonoBehaviour
{
    public Text text;
    public Image panelImage;

    GameController game;
    PlayerRange range; // to get the currently highlightet entity
    EntityScript entity;

    // Start is called before the first frame update
    void Start()
    {
        GameObject gameGo = GameObject.Find("CTRL_Game");
        if (gameGo == null)
        {
            Debug.LogError("No CTRL_Game object present! This means trouble.");
        }
        game = gameGo.GetComponent<GameController>();

        range = GetComponent<PlayerRange>();
        if (range == null)
        {
            Debug.LogWarning("No range script found");
        }
    }

    // Update is called once per frame
    void Update()
    {
        text.text = "";
        panelImage.enabled = false;

        if (range.currentObject != null)
        {
            entity = range.currentObject;
            text.text = entity.niceName;
            panelImage.enabled = true;


            if (game.allowPlayerInteractions)
            {
                if (Input.GetButtonDown("Interact1"))
                {
                    game.displayInteraction(entity.Interact());
                }
            }
        }
    }
}
