﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PlayerMovement : MonoBehaviour
{
    public float move_speed_max = 5;

    GameController game;
    Rigidbody2D body;
    Vector2 movement_in;
    float move_speed;
    float diagonal_fix = .66f;

    // Start is called before the first frame update
    void Start()
    {
        GameObject gameGo = GameObject.Find("CTRL_Game");
        if (gameGo == null)
        {
            Debug.LogError("No CTRL_Game object present! This means trouble.");
        }
        game = gameGo.GetComponent<GameController>();

        move_speed = move_speed_max;
        body = GetComponent<Rigidbody2D>();
    }

    // Update is called once per frame
    void Update()
    {
        if (game.allowPlayerMovement)
        {
            movement_in.x = Input.GetAxisRaw("Horizontal");
            movement_in.y = Input.GetAxisRaw("Vertical");
        }
        else
        {
            movement_in = new Vector2(0,0);
        }
    }

    void FixedUpdate()
    {
        // diagonal movement
        if (movement_in.x > 0 && movement_in.y > 0)
        {
            movement_in *= diagonal_fix;
        }

        body.MovePosition(body.position + movement_in * move_speed * Time.fixedDeltaTime);
    }
}
