﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class PlayerRange : MonoBehaviour
{
    public GameController game;
    public Collider2D[] playerColldiers; 
    public float range = .7f;
    public float rangeOffsetX = 0;
    public float rangeOffsetY = 0;

    public EntityScript currentObject;

    Vector3 offset;
    Collider2D[] objectsInRange;

    // Start is called before the first frame update
    void Start()
    {
        objectsInRange = new Collider2D[10];
        offset = new Vector3(rangeOffsetX, rangeOffsetY, 0f);
    }

    // Update is called once per frame
    void Update()
    {
        currentObject = null;
        Debug.DrawLine(new Vector3(transform.position.x + rangeOffsetX,
                                   transform.position.y + rangeOffsetY,
                                   transform.position.z),
                       new Vector3(transform.position.x + rangeOffsetX + range,
                                   transform.position.y + rangeOffsetY + range,
                                   transform.position.z),
                       Color.red);

        int results = Physics2D.OverlapCircleNonAlloc(transform.position + offset, range, objectsInRange);

        // hacky: remove player's colliders

        if (results > 0)
        {
            foreach (Collider2D c in objectsInRange)
            {
                if (c == null)
                {
                    continue;
                }

                EntityScript entity = c.GetComponent<EntityScript>();
                if (entity != null)
                {
                    currentObject = entity; 
                }
            }
        }
        Array.Clear(objectsInRange, 0, 10);
    }
}

