﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class StorySequence : MonoBehaviour
{
    public DialogSceneObject[] scenes;
    int currentScene = 0;

    bool validateScene(int sceneIndex)
    {
        if (sceneIndex < 0)
        {
            Debug.Log("sceneIndex less than 0:" + sceneIndex.ToString());
            return false;
        }
        if (sceneIndex > scenes.Length - 1)
        {
            Debug.Log("sceneIndex greater than array length:" + sceneIndex.ToString());
            return false;
        }
        return true;
    }



    DialogSceneObject getScene(int sceneIndex)
    {
        // returns scene WITHOUT setting the index
        if (!validateScene(sceneIndex)) { return null; }

        return scenes[sceneIndex];
    }
    public DialogSceneObject setScene(int sceneIndex)
    {
        // returns scene and sets the index
        currentScene = sceneIndex;
        return getScene(currentScene);
    }

    public DialogSceneObject getFirstScene()
    {
        // sets the index to 0 & returns that scene
        currentScene = 0;
        return scenes[0];
        //return setScene(0);
    }

    public DialogSceneObject getNextScene()
    {
        // increments index & returns that scene
        return setScene(++currentScene);
    }

    public bool IsLastScene()
    {
        if (currentScene == scenes.Length - 1)
        {
            return true;
        }
        return false; 
    }

}

