﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class TextController : MonoBehaviour
{
    public Text textbox;
    public Text choicesBox;
    public Image panelBackground;
    public Image imageFull;
    public float textTimeoutPerChar = .08f;

    GameController game;

    DialogSceneObject lastDialog;
    DialogSceneObject thisDialog;
    DialogSceneObject nextDialog;
    
    bool runCounter = false;
    float counter = 0;

    // Start is called before the first frame update
    void Start()
    {
        GameObject gameGo = GameObject.Find("CTRL_Game");
        if (gameGo == null)
        {
            Debug.LogError("No CTRL_Game object present! This means trouble.");
        }
        game = gameGo.GetComponent<GameController>();

        choicesBox.enabled = false;
    }

    // Update is called once per frame
    void Update()
    {

        if (runCounter)
        {
            counter -= Time.deltaTime;
            if (counter <= 0)
            {
                clearBox();
                runCounter = false;
            }
        }
    }

    public void doDialogScene(DialogSceneObject dialog)
    {
        if (dialog == null)
        {
            //Debug.Log("Dialog was null");
            return;
        }

        lastDialog = thisDialog;
        thisDialog = dialog;
        nextDialog = thisDialog.nextScene;


        // add to inventory
        if (thisDialog.addToInventoryOfNothing != "")
        {
            game.addNothing(thisDialog.addToInventoryOfNothing);
        }

        // play music
        if (thisDialog.musicClip != null)
        {
            bool startMusic = true; 
            if (game.musicPlayer.isPlaying)
            {
                if (game.musicPlayer.clip == thisDialog.musicClip)
                {
                    startMusic = false;
                }
            }

            if (startMusic)
            {
                game.musicPlayer.clip = thisDialog.musicClip;
                game.musicPlayer.loop = thisDialog.musicLoops;
                game.musicPlayer.volume = thisDialog.musicVolume;

                //start music player
                game.musicPlayer.Play();
            }
        }



        // branching
        {
            // HACK!
            switch (thisDialog.id)
            {
                case "outro_branch_1":
                    {
                        Debug.Log("outro_branch_1");
                        // if the length of nothings is 0
                        if (game.nothings == null || game.nothings.Count == 0)
                        {
                            Debug.Log("-A-");
                            nextDialog = thisDialog.choiceScenes[0];
                        }
                        else if (game.nothings.Count <= 2)
                        {
                            // if the length of nothings is less than 2
                            Debug.Log("-B-");
                            nextDialog = thisDialog.choiceScenes[1];
                        }
                        else
                        {
                            Debug.Log("-C-");
                            nextDialog = thisDialog.choiceScenes[2];
                        }

                        doFullImage(true); // swiotch to full screen images
                        doDialogScene(nextDialog);
                    } break;
            }
        }

        runCounter = false;
        if (thisDialog.secondsUntilFadeOut > 0)
        {
            runCounter = true;
            counter = thisDialog.secondsUntilFadeOut;
        }

        if (thisDialog.fullscreenImage != null)
        {
            imageFull.sprite = thisDialog.fullscreenImage;
        }

        

        choicesBox.enabled = false;
        string choicesString = "";
        if (thisDialog.choices.Length > 0)
        {
            choicesBox.enabled = true; // enable text box to display choices
            nextDialog = thisDialog;   // that it loops back to itself until there was a valid choice

            if (thisDialog.choices.Length != thisDialog.choices.Length)
            {
                Debug.LogWarning("Choices arrays don't match in " + gameObject.name);
            }
            else
            {
                choicesString = makeChoicesString(thisDialog.choices);
            }
        }
        else
        {
            // if there are no choices

            // if there's yet another
            if (!runCounter)
            {
                choicesBox.enabled = true;
                choicesString = "— E or [SPACE] —";
            }
        }

        if (thisDialog != lastDialog)
        {
            // play sound

            if (thisDialog.soundEffectClip == null)
            {
                game.sfxPlayer.clip = game.soundConfirm1;
                game.sfxPlayer.Play();
            }
            else
            {
                game.sfxPlayer.clip = thisDialog.soundEffectClip;
                game.sfxPlayer.Play();
            }


            doText(thisDialog.paragraphText, choicesString);
        }


    }

    public void doChoice(int choice)
    {
        // bounce
        if (thisDialog == null)
        {
            return;
        }

        // do choice on the currently displayed dialog
        if (thisDialog.choices.Length > 0)
        {
            if (choice == 1 && thisDialog.choiceScenes.Length >= 1)
            {
                // check if valid
                nextDialog = thisDialog.choiceScenes[0];
            }
            else if (choice == 2 && thisDialog.choiceScenes.Length >= 2)
            {
                // check if valid
                nextDialog = thisDialog.choiceScenes[1];
            }
            else if (choice == 3 && thisDialog.choiceScenes.Length >= 3)
            {
                // check if valid
                nextDialog = thisDialog.choiceScenes[2];
            }
        }
        else
        {
            if (choice <= 0)
            {
                //
            }
        }
    }

    public DialogSceneObject getNextDialog()
    {
        return nextDialog;
    }

    public void doText(string textString, string choicesString)
    {
        // string replacements
        string replacedString = textString.Replace("$NOTHINGS", game.listNothings());

        textbox.text = replacedString;
        choicesBox.text = choicesString;

        textbox.canvasRenderer.SetAlpha(0.0f);
        textbox.CrossFadeAlpha(1f, 0.25f, true);

        panelBackground.canvasRenderer.SetAlpha(0.0f);
        panelBackground.CrossFadeAlpha(1f, 0.25f, true);
    }

    string makeChoicesString(string[] choices)
    {
        string outString = "";
        int counter = 1;
        foreach (string s in choices)
        {
            outString += counter.ToString() + ". " + s + "\n";
            counter++;
        }

        return outString;
    }

    public void clearBox()
    {
        textbox.CrossFadeAlpha(0.0f, 0.5f, false);
        choicesBox.CrossFadeAlpha(0.0f, 0.5f, false);
        panelBackground.CrossFadeAlpha(0.0f, 0.5f, false);
        lastDialog = null;
        thisDialog = null;
        //textbox.text = "";
    }

    public void doFullImage(bool doIt)
    {
        if (doIt)
        {
            imageFull.enabled = true;
        }
        else
        {
            imageFull.enabled = false;
        }
    }
}
